import Foundation

/// Custom error types for HealthKit operations in the death app
enum HealthKitError: LocalizedError {
    case notAvailable
    case authorizationFailed
    case dataUnavailable
    case invalidData
    case missingPermissions(types: [String])
    case queryFailed(String)
    
    var errorDescription: String? {
        switch self {
        case .notAvailable:
            return "HealthKit is not available on this device"
        case .authorizationFailed:
            return "Failed to authorize HealthKit access"
        case .dataUnavailable:
            return "Health data is not available"
        case .invalidData:
            return "Invalid health data format"
        case .missingPermissions(let types):
            return "Missing permissions for: \(types.joined(separator: ", "))"
        case .queryFailed(let reason):
            return "Health query failed: \(reason)"
        }
    }
}
