import SwiftUI

struct ContentView: View {
    var body: some View {
        NavigationView {
            VStack {
                Image(systemName: "heart.fill")
                    .imageScale(.large)
                    .foregroundStyle(.tint)
                Text("LifeClock")
                    .font(.title)
                    .fontWeight(.bold)
                
                Text("Companion app for LifeClock Watch")
                    .font(.subheadline)
                    .foregroundColor(.secondary)
                    .multilineTextAlignment(.center)
                    .padding()
                
                Spacer()
            }
            .navigationTitle("LifeClock")
            .padding()
        }
    }
}

#Preview {
    ContentView()
}